/*
 * C2DMReceiver
 * Handles C2DM notifications
 * 
 *  Disclaimer: IMPORTANT:  This sample software is supplied to you by Genesys
 Telecommunications Laboratories Inc ("Genesys") in consideration of your agreement
 to the following terms, and your use, installation, modification or redistribution
 of this Genesys software constitutes acceptance of these terms.  If you do not
 agree with these terms, please do not use, install, modify or redistribute this
 Genesys software.
 
 In consideration of your agreement to abide by the following terms, and subject
 to these terms, Genesys grants you a personal, non-exclusive license, under
 Genesys's copyrights in this original Genesys software (the "Genesys Software"), to
 use, reproduce, modify and redistribute the Genesys Software, with or without
 modifications, in source and/or binary forms; provided that if you redistribute
 the Genesys Software in its entirety and without modifications, you must retain
 this notice and the following text and disclaimers in all such redistributions
 of the Genesys Software.
 
 Neither the name, trademarks, service marks or logos of Genesys Inc. may be used
 to endorse or promote products derived from the Genesys Software without specific
 prior written permission from Genesys.  Except as expressly stated in this notice,
 no other rights or licenses, express or implied, are granted by Genesys herein,
 including but not limited to any patent rights that may be infringed by your
 derivative works or by other works in which the Genesys Software may be
 incorporated.
 
 The Genesys Software is provided by Genesys on an "AS IS" basis.  GENESYS MAKES NO
 WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED
 WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE, REGARDING THE GENESYS SOFTWARE OR ITS USE AND OPERATION ALONE OR IN
 COMBINATION WITH YOUR PRODUCTS.
 
 IN NO EVENT SHALL GENESYS BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL OR
 CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION, MODIFICATION AND/OR
 DISTRIBUTION OF THE GENESYS SOFTWARE, HOWEVER CAUSED AND WHETHER UNDER THEORY OF
 CONTRACT, TORT (INCLUDING NEGLIGENCE), STRICT LIABILITY OR OTHERWISE, EVEN IF
 GENESYS HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 
 Copyright (C) 2012 Genesys Inc. All Rights Reserved.

*/
package com.genesyslab.gms.android;


import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;

/*
 * Handles C2DM notifications
 */
public class C2DMReceiver extends BroadcastReceiver {
	@Override
	public void onReceive(Context context, Intent intent) {
		Log.d("C2DMReceiver.onReceive", "action:" + intent.getAction());
		if (intent.getAction().equals("com.google.android.c2dm.intent.REGISTRATION")) {
	        handleRegistration(context, intent);
	    } else if (intent.getAction().equals("com.google.android.c2dm.intent.RECEIVE")) {
	        handleMessage(context, intent);
	    }
	 }

	/*
	 * Handles registration notifications by passing pertinent data on to
	 * main activity class
	 */
	private void handleRegistration(Context context, Intent intent) {
		Log.d("C2DMReceiver.handleRegistration", "registration_id::" + intent.getStringExtra("registration_id") + ";error:" + intent.getStringExtra("error"));
		Bundle extras = new Bundle(); 
		extras.putString("type", "c2dmregistration");
    	extras.putString("registration_id", intent.getStringExtra("registration_id"));
    	extras.putString("error", intent.getStringExtra("error"));
        MessageHandler.getInstance().notifyObservers(extras);
	}

	/*
	 * Handles message notifications by passing pertinent data on to
	 * main activity class
	 */
	private void handleMessage(Context context, Intent intent) {
		Log.d("C2DMReceiver.handleMessage", "message:" + intent.getStringExtra("message"));
		Bundle extras = new Bundle();    	 
		extras.putString("type", "c2dmmessage");
    	extras.putString("message", intent.getStringExtra("message"));
    	// check to see if main activity class is registered which indicates the app is still running
    	// if it is then just notify it
    	// if it is not then use the android notification manager to create a notification that will launch the app when the user selects it
    	if(MessageHandler.getInstance().countObservers() > 0)
            MessageHandler.getInstance().notifyObservers(extras);
    	else
    		createMessageNotification(context, intent.getStringExtra("message"));
	}
	
	public void createMessageNotification(Context context, String message) {
		Log.d("C2DMReceiver.createMessageNotification", "message:" + message);
		NotificationManager notificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
		Notification notification = new Notification(R.drawable.genesys, "GMS Sample App Message received", System.currentTimeMillis());
		// Hide the notification after its selected
		notification.flags |= Notification.FLAG_AUTO_CANCEL;
		Intent intent = new Intent(context, GMSSampleAppMainActivity.class);
		intent.putExtra("type", "c2dmmessage");
		intent.putExtra("message", message);
		PendingIntent pendingIntent = PendingIntent.getActivity(context, 0,	intent, 0);
		notification.setLatestEventInfo(context, "GMS Sample App",	"Agent Available", pendingIntent);
		notificationManager.notify(0, notification);

	}

}
